//Dustin Soodak
//behavior 031: shot 22
//wandering with pretty lights
#include "MiscHardware.h"
#include "Navigation.h"
void MoveWithOptionsWandering(int Direction, int Speed, unsigned int Distance, unsigned int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), char Wiggle){
  uint32_t timeout,totaltimeout;
  int32_t initdist;//so don't overflow after too many calls
  char timeoutmode=0;
  int PrevDirection,PrevPosition;//only keeping track of y-direction for now.
  int Heading,Input,Output,Proportional,Integral=0,Derivative,ProportionalPrev,dist;
  int MinLeftEdge,MinRightEdge;
  char left,right,edge;
  signed char BackAway=0;
  char colormode=0;
  int dheading=0;
  int dheadingdir=1;
  int dheadingfinal=0;
  SwitchSerialToMotors();
  if(NavigationOn)
    ZeroNavigationSensors();
  else{
    NavigationBegin();
    PauseNavigation();
  }
  ResetLookAtEdge();    
  ResumeNavigation(); 
  SimpleNavigation();
  initdist=GetPositionY();
  Heading=Direction;    
  Motors(Speed,Speed);
  timeout=millis()+MaxExpectedRunTime;
  Input=GetDegrees()+GetDegreesToStop();
  ProportionalPrev=(Heading-Input);
  RestartTimer();
  while(1){//millis()<timeout
    SimpleNavigation(); 
    Input=GetDegrees()+GetDegreesToStop();
    if(dheadingdir==1){
      dheading++;
      if(dheading/5>dheadingfinal){
        dheadingdir=-1;
        dheadingfinal=random(0,360);
      }
    }
    else{
      dheading--;
      if(dheading/5<-dheadingfinal){
        dheadingdir=1;
      }
    }
    Proportional=(Heading+dheading/5-Input);
    Integral+=Proportional;
    Derivative=GetDegreesPerSecond();
    ProportionalPrev=Proportional;
    if(Integral/50>100)
      Integral=5000;
    if(Integral/50<-100)
      Integral=-5000; 
    Output=Proportional+Integral/50-(Wiggle==0?(3*Derivative/4):0);
    if(Output>0)
      Output+=Wiggle;
    else if(Output<0)
      Output-=Wiggle;
    if(Output>100)
      Output=100;
    if(Output<-100)
      Output=-100;    
    Motors(Speed+Output,Speed-Output);
    dist=GetPositionY()-initdist;
    //if((Distance>0 && dist>Distance) || (Distance<0 && dist<Distance))
    //  break;
    if(EdgeFunction){
      edge=LookForEdge();
      if(edge){
        EdgeFunction(edge);    
        if(Heading>0)
          Heading-=180;
        else
          Heading+=180;
        //break;//exit
      }
    }
  }
  Motors(0,0);     
  SwitchButtonToPixels();SetPixelRGB(5,H_Bright,H_Bright/3,H_Bright/3);SetPixelRGB(6,H_Bright,H_Bright/3,H_Bright/3);//for behavior 030
  timeout=millis()+MaxExpectedSkidTime;
  totaltimeout=timeout;
  while(millis()<timeout){
    SimpleNavigation(); 
    if(GetDegreesPerSecond()==0){
      if(timeoutmode==0){
        timeout=millis()+100;//see if it will stay still for 100ms
        timeoutmode=1;
      }
    }
    else{
      if(timeoutmode==1){
        timeout=totaltimeout;
        timeoutmode=0;
      }
    }
  }
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);colormode=0;
}
void BackAwayFunction(char c){
  Motors(-200,-200);
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  RestartTimer();
  while(GetTime()<100){
    SimpleNavigation();
  }
  Motors(-150,-150);
  while(GetTime()<100){
    SimpleNavigation();
  }
  SetPixelRGB(5,0,100,0);SetPixelRGB(6,0,100,0);SetPixelRGB(2,100,0,100);SetPixelRGB(3,0,0,100);RefreshPixels();
  SwitchPixelsToButton();
  Motors(0,0);
}
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
}
int i;
void loop(){
  SwitchPixelsToButton();SwitchMotorsToSerial();
  RestartTimer();  
  RxIRRestart();
  while(1){
    if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      if(IRBytes[2]==0x45 && IRBytes[3]==0xBA){//power//if(IRBytes[2]==0x44 && IRBytes[3]==0xBB)//test//
        IRBytes[2]=0;IRBytes[3]=0;break;
      }
      else{
        RxIRRestart();SwitchPixelsToButton();
      }       
    }//end if(IsIRDone())
    if(ButtonPressed()){
      delay(1000);break; 
    }
  }//end while(1) wait for robot or IR button
  randomSeed(millis());
  SwitchButtonToPixels();
  SetPixelRGB(5,0,100,0);SetPixelRGB(6,0,100,0);SetPixelRGB(2,100,0,100);SetPixelRGB(3,0,0,100);RefreshPixels();
  MoveWithOptionsWandering(0, 100, 60000, 60000, 500, BackAwayFunction, 0);
  RotateAccurate(180, 2000);
  SetAllPixelsRGB(0,0,0);RefreshPixels();
  ZeroNavigation();  
}



